/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.pdu.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.RIPPacket;
import com.cisco.pt.ipc.sim.pdu.RIPRoutePacket;
import com.cisco.pt.ipc.sim.pdu.impl.PduImpl;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RIPPacketImpl
extends PduImpl
implements RIPPacket {
    protected Byte command;
    protected Byte version;
    protected Short routingDomain;
    protected List<RIPRoutePacket> routes;
    protected boolean isRedistributed;

    public RIPPacketImpl() {
        this.fieldNames.add("RIPPacketImpl_command");
        this.fieldNames.add("RIPPacketImpl_version");
        this.fieldNames.add("RIPPacketImpl_routingDomain");
        this.fieldNames.add("RIPPacketImpl_routes");
        this.fieldNames.add("RIPPacketImpl_isRedistributed");
        this.signalType = "RipPacket";
    }

    @Override
    public Byte getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(Byte command) {
        this.command = command;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("RIPPacketImpl_command")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("RIPPacketImpl_command", command));
            return;
        }
    }

    @Override
    public Byte getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Byte version) {
        this.version = version;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("RIPPacketImpl_version")) continue;
            this.fieldTable.set(i, new Pair<String, Byte>("RIPPacketImpl_version", version));
            return;
        }
    }

    @Override
    public Short getRoutingDomain() {
        return this.routingDomain;
    }

    @Override
    public void setRoutingDomain(Short routingDomain) {
        this.routingDomain = routingDomain;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("RIPPacketImpl_routingDomain")) continue;
            this.fieldTable.set(i, new Pair<String, Short>("RIPPacketImpl_routingDomain", routingDomain));
            return;
        }
    }

    @Override
    public List<RIPRoutePacket> getRoutes() {
        return this.routes;
    }

    @Override
    public void setRoutes(List<RIPRoutePacket> routes) {
        this.routes = routes;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("RIPPacketImpl_routes")) continue;
            this.fieldTable.set(i, new Pair<String, List<RIPRoutePacket>>("RIPPacketImpl_routes", routes));
            return;
        }
    }

    @Override
    public boolean getIsRedistributed() {
        return this.isRedistributed;
    }

    @Override
    public void setIsRedistributed(boolean isRedistributed) {
        this.isRedistributed = isRedistributed;
        for (int i = 0; i < this.fieldTable.size(); ++i) {
            Pair item = (Pair)this.fieldTable.get(i);
            if (!((String)item.getFirst()).equalsIgnoreCase("RIPPacketImpl_isRedistributed")) continue;
            this.fieldTable.set(i, new Pair<String, Boolean>("RIPPacketImpl_isRedistributed", isRedistributed));
            return;
        }
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("RIPPacketImpl_command")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("RIPPacketImpl_version")) {
            return PtmpTypeValue.BYTE;
        }
        if (fieldName.equals("RIPPacketImpl_routingDomain")) {
            return PtmpTypeValue.SHORT;
        }
        if (fieldName.equals("RIPPacketImpl_routes")) {
            return PtmpTypeValue.DATA;
        }
        if (fieldName.equals("RIPPacketImpl_isRedistributed")) {
            return PtmpTypeValue.BOOL;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, Byte>("RIPPacketImpl_command", this.command));
        this.fieldTable.add(new Pair<String, Byte>("RIPPacketImpl_version", this.version));
        this.fieldTable.add(new Pair<String, Short>("RIPPacketImpl_routingDomain", this.routingDomain));
        this.fieldTable.add(new Pair<String, List<RIPRoutePacket>>("RIPPacketImpl_routes", this.routes));
        this.fieldTable.add(new Pair<String, Boolean>("RIPPacketImpl_isRedistributed", this.isRedistributed));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.command = this.readByte(buffer);
        this.version = this.readByte(buffer);
        this.routingDomain = this.readShort(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.routes = new ArrayList<RIPRoutePacket>();
        for (Object o : tempList1) {
            this.routes.add((RIPRoutePacket)o);
        }
        this.isRedistributed = this.readBoolean(buffer);
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.command = this.pduReadByte(buffer);
        this.version = this.pduReadByte(buffer);
        this.routingDomain = this.pduReadShort(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)16);
        this.routes = new ArrayList<RIPRoutePacket>();
        for (Object o : tempList1) {
            this.routes.add((RIPRoutePacket)o);
        }
        this.isRedistributed = this.pduReadBoolean(buffer);
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putByte(this.command);
        buffer.putByte(this.version);
        buffer.putShort(this.routingDomain);
        buffer.putInt(this.routes.size());
        for (RIPRoutePacket item : this.routes) {
            item.encodeTypeAndPayload(buffer);
        }
        buffer.putBool(this.isRedistributed);
    }
}

